﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using WatchBPO3;
using WatchBPO3.Decode;

namespace WatchBPSampleCode
{
    public partial class MainFrm : Form
    {
        WatchBPO3Hid watchBPO3Hid;
        DataType currentDataType;
        WatchBPO3Ver watchBPO3Ver;
        string currentID = string.Empty;
        byte[] versionByteAry, idByteAry, datetimeByteAry, casualDataByteAry, diagnosticDataByteAry, 
               abpDataByteAry, memoDataByteAry, abpSettingByteAry, bpmSettingByteAry, ABPMSettingByteAry
               , snDataByteAry,btModuleNameByteAry, deviceIDByteAry, measuretimesByteAry;
        bool IsOscillometric_Map = false;
        public enum DataType
        {
            none,
            userID,
            version,
            deviceDatetime,
            casualData,
            diagnosticData,
            abpData,
            memoData,
            abpSetting,
            bpmSetting,
            serialNumberData,
            deviceID,
        }

        // WH021(major),Wh022: 30h; WH023, WH025(major): 40h
        public enum WatchBPO3Ver
        {
            none,
            WH021,
            WH022,
            //WH023, //Phase Out
            WH025,
            WH033,
            WH034,
            WH035,
            WH02A,
            WH02B,
            WH02C,
            WH02D,
            WH03A,
            WH03B,
            WH03C
        }

        public MainFrm()
        {
            InitializeComponent();
            watchBPO3Hid = new WatchBPO3Hid();
        }

        private void btn_checkKey_Click(object sender, EventArgs e)
        {
            try
            {
                // Initial usb hid
                USBInit();
                watchBPO3Hid.InitWatchBPSDK(tb_key.Text);
                watchBPO3Hid.RegisterHandle(Handle);
                tb_key.ReadOnly = true;
                btn_checkKey.Enabled = false;
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }

        #region Usbhid-related

        protected override void WndProc(ref Message m)
        {
            base.WndProc(ref m);	// pass message on to base form
            watchBPO3Hid.ParseMessages(ref m);
        }

        private void USBInit()
        {
            // event
            watchBPO3Hid.SpecifiedDeviceRemoved += new EventHandler( watchBPO3_OnSpecifiedDeviceRemoved);
            watchBPO3Hid.SpecifiedDeviceArrived += new EventHandler( watchBPO3_OnSpecifiedDeviceArrived);
        }

        private void watchBPO3_OnSpecifiedDeviceRemoved(object sender, EventArgs e)
        {
            this.Invoke((MethodInvoker)delegate
            {
                ChangeAllBtnStatus(false);
                tb_id.Text = string.Empty;
                listBox_data.Items.Clear();
                lb_status.Text = "Disconnected!";
                lb_status.ForeColor = Color.Red;
            });
            currentID = string.Empty;
            watchBPO3Ver = WatchBPO3Ver.none;
        }

        private void watchBPO3_OnSpecifiedDeviceArrived(object sender, EventArgs e)
        {
            this.Invoke((MethodInvoker)delegate {
                lb_status.Text = "Device Connected!";
                lb_status.ForeColor = Color.Blue;
                btn_version.Enabled = true;
            });
        }
        #endregion

        private void btn_decode_Click(object sender, EventArgs e)
        {
            if (listBox_raw.Items.Count > 0 && currentDataType != DataType.none)
            {
                listBox_data.Items.Clear();
                switch (currentDataType)
                {

                   
                    case DataType.version:
                        string deviceName;
                        if (DeviceInfoParser.ParseDeviceName(versionByteAry, out deviceName))
                        {
                            switch (deviceName)
                            {
                                case "WH021":                               
                                    watchBPO3Ver = WatchBPO3Ver.WH021;
                                    break;
                                case "WH022":                               
                                    watchBPO3Ver = WatchBPO3Ver.WH022;
                                    break;
          //                      case "WH023":
          //                          ShowPhaseOutMsg();
          //                          break;
                                case "WH025":                                
                                    watchBPO3Ver = WatchBPO3Ver.WH025;
                                    break;
                                case "WH033":
                                    watchBPO3Ver = WatchBPO3Ver.WH033;
                                    break;
                                case "WH034":
                                    watchBPO3Ver = WatchBPO3Ver.WH034;
                                    break;
                                case "WH035":
                                    watchBPO3Ver = WatchBPO3Ver.WH035;
                                    break;

                                case "WH02A":
                                    watchBPO3Ver = WatchBPO3Ver.WH02A;
                                    break;
                                case "WH02B":
                                    watchBPO3Ver = WatchBPO3Ver.WH02B;
                                    break;
                                case "WH02C":
                                    watchBPO3Ver = WatchBPO3Ver.WH02C;
                                    break;
                                case "WH02D":
                                    watchBPO3Ver = WatchBPO3Ver.WH02D;
                                    break;
                                case "WH03A":
                                    watchBPO3Ver = WatchBPO3Ver.WH03A;
                                    break;
                                case "WH03B":
                                    watchBPO3Ver = WatchBPO3Ver.WH03B;
                                    break;
                                case "WH03C":
                                    watchBPO3Ver = WatchBPO3Ver.WH03C;
                                    break;
                                default:
                                    ShowConnectDeviceMsg();
                                    break;
                            }
                            listBox_data.Items.Add(deviceName);
                            ChangeAllBtnStatus(true);
                        }
                        else
                            ShowDecodeErrMsg();
                        break;

                    case DataType.userID:
                        string id;
                        if (DeviceInfoParser.ParseDeviceID(idByteAry, out id))
                        {
                            listBox_data.Items.Add(id);
                            currentID = id;
                            tb_id.Text = id;
                        }
                        else
                            ShowDecodeErrMsg();
                        break;

                    case DataType.deviceDatetime:
                        string deviceDateTime;
                        if (DeviceInfoParser.ParseDeviceDateTime(datetimeByteAry, out deviceDateTime))
                            listBox_data.Items.Add(deviceDateTime);
                        else
                            ShowDecodeErrMsg();
                        break;
                    case DataType.casualData:
                        List<Data> casualData;
                        if (DataParser.ParseUsuData(casualDataByteAry, out casualData))
                        {
                            for (int i = 0; i < casualData.Count; i++)
                            {
                                if (watchBPO3Hid.support_Afib)
                                {
                                    string casualDataStr = string.Format(
                                      "MeasureDatetime: {0}, DataType: {1}, Sys: {2}, Dia: {3}, Pulse: {4},Afib: {5}",
                                      casualData[i].MeasureDateTime, casualData[i].DataType, casualData[i].Systole, casualData[i].Diastole,
                                      casualData[i].Pulse, casualData[i].Arr
                                      );
                                    listBox_data.Items.Add(casualDataStr);
                                }
                                else
                                {
                                    string casualDataStr = string.Format(
                                        "MeasureDatetime: {0}, DataType: {1}, Sys: {2}, Dia: {3}, Pulse: {4}",
                                        casualData[i].MeasureDateTime, casualData[i].DataType, casualData[i].Systole, casualData[i].Diastole,
                                        casualData[i].Pulse
                                        );
                                    listBox_data.Items.Add(casualDataStr);
                                }
                            }
                        }
                        else
                            ShowDecodeErrMsg();
                        break;
                    case DataType.diagnosticData:
                        List<Data> diagnosticData;
                        if (DataParser.ParseDiagData(diagnosticDataByteAry, out diagnosticData))
                        {
                            for (int i = 0; i < diagnosticData.Count; i++)
                            {
                                string diagDataStr = string.Format(
                                    "MeasureDatetime: {0}, DataType: {1}, Sys: {2}, Dia: {3}, Pulse: {4}",
                                    diagnosticData[i].MeasureDateTime, diagnosticData[i].DataType, diagnosticData[i].Systole, diagnosticData[i].Diastole,
                                    diagnosticData[i].Pulse
                                    );
                                listBox_data.Items.Add(diagDataStr);
                            }
                        }
                        else
                            ShowDecodeErrMsg();
                        break;
                    case DataType.abpData:
                        List<Data> abpData = new List<Data>();
                        bool decodeErr = false;

                        if (!watchBPO3Hid.support_Oscillometric_MAP)
                            decodeErr = !DataParser.ParseABPData(abpDataByteAry, out abpData);
                        else
                            decodeErr = !DataParser.ParseABPDataE315(abpDataByteAry, out abpData);

                        if (!decodeErr)
                        {
                            if (!watchBPO3Hid.support_Oscillometric_MAP)
                            {
                                for (int i = 0; i < abpData.Count; i++)
                                {
                                    string abpDataStr;
                                    // check err
                                    if (abpData[i].ErrMsg != Data.ErrMsgEnum.none)
                                        abpDataStr = string.Format("MeasureDatetime: {0}, ErrMsg: {1}, Err: {2}", abpData[i].MeasureDateTime, abpData[i].ErrMsg, abpData[i].Err);
                                    else
                                        abpDataStr = string.Format(
                                        "MeasureDatetime: {0}, DataType: {1}, Sys: {2}, Dia: {3}, Pulse: {4}",
                                        abpData[i].MeasureDateTime, abpData[i].DataType, abpData[i].Systole, abpData[i].Diastole,
                                        abpData[i].Pulse
                                        );
                                    listBox_data.Items.Add(abpDataStr);
                                }
                            }
                            else
                            {
                                for (int i = 0; i < abpData.Count; i++)
                                {
                                    string abpDataStr;
                                    // check err
                                    if (abpData[i].ErrMsg != Data.ErrMsgEnum.none)
                                        abpDataStr = string.Format("MeasureDatetime: {0}, ErrMsg: {1}, Err: {2}", abpData[i].MeasureDateTime, abpData[i].ErrMsg, abpData[i].Err);
                                    else {
                                        string MAP_Type = "";
                                        if (IsOscillometric_Map)
                                            MAP_Type = "OPP";
                                        else
                                            MAP_Type = "FMAP";
                                        if (watchBPO3Hid.support_Afib)
                                        {
                                            abpDataStr = string.Format(
                                  "MeasureDatetime: {0}, DataType: {1}, Sys: {2}, Dia: {3}, Pulse: {4},{7}: {5} ,Afib: {6}",
                                  abpData[i].MeasureDateTime, abpData[i].DataType, abpData[i].Systole, abpData[i].Diastole,
                                  abpData[i].Pulse, abpData[i].MAP, abpData[i].Arr,MAP_Type
                                  );
                                        }
                                        else
                                        {
                                            abpDataStr = string.Format(
                                            "MeasureDatetime: {0}, DataType: {1}, Sys: {2}, Dia: {3}, Pulse: {4},{6}: {5} ",
                                            abpData[i].MeasureDateTime, abpData[i].DataType, abpData[i].Systole, abpData[i].Diastole,
                                            abpData[i].Pulse, abpData[i].MAP,MAP_Type
                                            );
                                        }
                                }
                                    listBox_data.Items.Add(abpDataStr);
                                }
                            }
                        }
                        else
                            ShowDecodeErrMsg();
                        break;
                    case DataType.memoData:
                        List<string> memoData;
                        if (DataParser.ParseMemoData(memoDataByteAry, out memoData))
                        {
                            for (int i = 0; i < memoData.Count; i++)
                            {
                                listBox_data.Items.Add(memoData[i]);
                            }
                        }
                        else
                            ShowDecodeErrMsg();
                        break;
                    case DataType.abpSetting:
                        ABPSetting abpSetting;
                        if (DeviceInfoParser.ParseABPSetting(abpSettingByteAry, out abpSetting))
                        {
                            PrintAllProperties(abpSetting);
                            cb_dayPeriod.SelectedIndex = int.Parse(abpSetting.DayPeriod);
                            cb_nightPeriod.SelectedIndex = int.Parse(abpSetting.NightPeriod);
                            cb_dayInterval.SelectedItem = abpSetting.DayInterval;
                            cb_nightInterval.SelectedItem = abpSetting.NightInterval;
                            cb_HiInfPressure.SelectedItem = abpSetting.Hi_infPressure;
                            if (abpSetting.HideABPMData)
                                cb_hideABPM.SelectedIndex = 0;
                            else
                                cb_hideABPM.SelectedIndex = 1;
                            if (abpSetting.Silent)
                                cb_silent.SelectedIndex = 0;
                            else
                                cb_silent.SelectedIndex = 1;
                        }
                        else
                            ShowDecodeErrMsg();
                        break;
                    case DataType.bpmSetting:
                        BPMSetting bpmSetting;
                        if (DeviceInfoParser.ParseBPMSetting(bpmSettingByteAry, out bpmSetting))
                        {
                            listBox_data.Items.Add("Diag Times: " + bpmSetting.DiagTimes);
                            listBox_data.Items.Add("EveAFrom: " + bpmSetting.EveAFrom);
                            listBox_data.Items.Add("EveATo: " + bpmSetting.EveATo);
                            listBox_data.Items.Add("MemorySet: " + bpmSetting.MemorySet);
                            listBox_data.Items.Add("MorAFrom: " + bpmSetting.MorAFrom);
                            listBox_data.Items.Add("MorATo: " + bpmSetting.MorATo);
                            listBox_data.Items.Add("REST Time: " + bpmSetting.RESTTime);
                            listBox_data.Items.Add("Wait Time: " + bpmSetting.WaitTime);
                            listBox_data.Items.Add("Working Day: " + bpmSetting.WorkingDay);
                            listBox_data.Items.Add("---------------------------------------------------------");
                            listBox_data.Items.Add("Setting1: ");
                            PrintAllProperties(bpmSetting.Setting1);
                            listBox_data.Items.Add("---------------------------------------------------------");
                            listBox_data.Items.Add("Setting2: ");
                            PrintAllProperties(bpmSetting.Setting2);

                            listBox_data.Items.Add("---------------------------------------------------------");
                            listBox_data.Items.Add("Setting3: ");
                            PrintAllProperties(bpmSetting.Setting3);
                        }
                        else
                            ShowDecodeErrMsg();
                        break;

                    case DataType.serialNumberData:
                        string serialnumber ;
                         if (DeviceInfoParser.ParseDeviceSerialNumber(snDataByteAry, out serialnumber))
                         {
                            listBox_data.Items.Add(serialnumber);
                            tb_SN.Text = serialnumber;
                        } 
                         else
                             ShowDecodeErrMsg(); 
                        break;
                    case DataType.deviceID:
                        string DeviceID;
                        if (DeviceInfoParser.ParseDeviceUUID(deviceIDByteAry, out DeviceID))
                        {
                            listBox_data.Items.Add(DeviceID);
                            tb_Device_ID.Text = DeviceID;
                        }
                        else
                            ShowDecodeErrMsg();
                        break;
                }
                currentDataType = DataType.none;
            }
        }
        private void PrintAllProperties(object obj)
        {
            foreach (PropertyDescriptor descriptor in TypeDescriptor.GetProperties(obj))
            {
                string name = descriptor.Name;
                object value = descriptor.GetValue(obj);
                listBox_data.Items.Add(String.Format("{0}: {1}", name.Replace("_"," "), value));
            }
        }
        private void btn_readDeviceDateTime_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                currentDataType = DataType.deviceDatetime;
                listBox_data.Items.Clear();
                datetimeByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadDeviceDateTime);
                LoadDataToListBox(datetimeByteAry);
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_readAbpData_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                this.Cursor = Cursors.WaitCursor;
                currentDataType = DataType.abpData;
                listBox_data.Items.Clear();
                abpDataByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadABPData);
                this.Cursor = Cursors.Default;
                if (!CheckDataExist(abpDataByteAry))
                    return;               
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_setID_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                if (!string.IsNullOrWhiteSpace(tb_id.Text))
                {
                    this.Cursor = Cursors.WaitCursor;
                    if (watchBPO3Hid.SendIDAndClearData(tb_id.Text.Trim(), false, false, false, false))
                        ShowSetSuccessMsg(true);
                    else
                        ShowSetSuccessMsg(false);
                    this.Cursor = Cursors.Default;
                }  
                else
                    MessageBox.Show("Please enter the id");
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_readID_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                currentDataType = DataType.userID;
                listBox_data.Items.Clear();
                idByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadID);
                LoadDataToListBox(idByteAry);
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }


        private void btn_clearUsual_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                if (!string.IsNullOrWhiteSpace(currentID))
                {
                    this.Cursor = Cursors.WaitCursor;
                    if (watchBPO3Hid.SendIDAndClearData(currentID, true, false, false, false))
                        ShowSetSuccessMsg(true);
                    else
                        ShowSetSuccessMsg(false);
                    this.Cursor = Cursors.Default;
                }   
                else
                    ShowGetIDMsg();
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_clearDia_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                if (!string.IsNullOrWhiteSpace(currentID))
                {
                    this.Cursor = Cursors.WaitCursor;
                    if (watchBPO3Hid.SendIDAndClearData(currentID, false, true, false, false))
                        ShowSetSuccessMsg(true);
                    else
                        ShowSetSuccessMsg(false);
                    this.Cursor = Cursors.Default;
                }   
                else
                    ShowGetIDMsg();
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_clrMemo_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                if (!string.IsNullOrWhiteSpace(currentID))
                {
                    this.Cursor = Cursors.WaitCursor;
                    if (watchBPO3Hid.SendIDAndClearData(currentID, false, false, false, true))
                        ShowSetSuccessMsg(true);
                    else
                        ShowSetSuccessMsg(false);
                    this.Cursor = Cursors.Default;
                }    
                else
                    ShowGetIDMsg();
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_clrAbp_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                if (!string.IsNullOrWhiteSpace(currentID))
                {
                    this.Cursor = Cursors.WaitCursor;
                    if (watchBPO3Hid.SendIDAndClearData(currentID, false, false, true, false))
                        ShowSetSuccessMsg(true);
                    else
                        ShowSetSuccessMsg(false);
                    this.Cursor = Cursors.Default;
                }   
                else
                    ShowGetIDMsg();
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_clearAll_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                if (!string.IsNullOrWhiteSpace(currentID))
                {
                    this.Cursor = Cursors.WaitCursor;
                    if (watchBPO3Hid.SendIDAndClearData(currentID, true, true, true, true))
                        ShowSetSuccessMsg(true);
                    else
                        ShowSetSuccessMsg(false);
                    this.Cursor = Cursors.Default;
                }    
                else
                    ShowGetIDMsg();
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_readAbpSetting_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                currentDataType = DataType.abpSetting;
                listBox_data.Items.Clear();
                abpSettingByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadABPSetting);
                LoadDataToListBox(abpSettingByteAry);
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_readMemoData_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                this.Cursor = Cursors.WaitCursor;
                currentDataType = DataType.memoData;

                listBox_data.Items.Clear();
                memoDataByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadMemoData);
                this.Cursor = Cursors.Default;
                if (!CheckDataExist(memoDataByteAry))
                    return;
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_sendPCdatetime_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                this.Cursor = Cursors.WaitCursor;
                if (watchBPO3Hid.SendPCDateTime())
                    ShowSetSuccessMsg(true);
                else
                    ShowSetSuccessMsg(false);
                this.Cursor = Cursors.Default;
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_readABPDataWH025_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                IsOscillometric_Map = true;
                this.Cursor = Cursors.WaitCursor;
                currentDataType = DataType.abpData;
                listBox_data.Items.Clear();
                abpDataByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadABPDataE315);
                this.Cursor = Cursors.Default;
                if (!CheckDataExist(abpDataByteAry))
                    return;               
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_readDiaData_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                this.Cursor = Cursors.WaitCursor;
                currentDataType = DataType.diagnosticData;

                listBox_data.Items.Clear();
                diagnosticDataByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadDiagnosticData);
                this.Cursor = Cursors.Default;
                if (!CheckDataExist(diagnosticDataByteAry))
                    return;
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_readCasualData_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                this.Cursor = Cursors.WaitCursor;
                currentDataType = DataType.casualData;
                listBox_data.Items.Clear();
                casualDataByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadCasualData);
                this.Cursor = Cursors.Default;
                if (!CheckDataExist(casualDataByteAry))
                    return;
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }

        private void btn_version_Click(object sender, EventArgs e)
        {
            versionByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.RequestDeviceVer);
            string versionStr = string.Empty;

            if (watchBPO3Hid.CanCommunication)
            {
                currentDataType = DataType.version;
                listBox_data.Items.Clear();
                lb_status.Text = "Device Connected!";
                lb_status.ForeColor = Color.Blue;
                LoadDataToListBox(versionByteAry);
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }


        private void setPeriodUI(ComboBox timeStart, ComboBox timeEnd, ComboBox interval,CheckBox silentCheckBox, bool value)            
        {
            timeStart.Enabled = value;
            timeEnd.Enabled = value;
            interval.Enabled = value;
            silentCheckBox.Enabled = value;
            if (value == true)
            {
                if (timeStart.SelectedIndex == -1)
                    timeStart.SelectedIndex = 0;
                if (timeEnd.SelectedIndex == -1)
                    timeEnd.SelectedIndex = 23;
                if (interval.SelectedIndex == -1)
                    interval.SelectedIndex = 2;
            }
            else
                silentCheckBox.Checked = false;
        }
     
        private void listBox_data_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Control && (e.KeyCode == Keys.C))
            {
                System.Text.StringBuilder copy_buffer = new System.Text.StringBuilder();
                foreach (object item in listBox_data.SelectedItems)
                    copy_buffer.AppendLine(item.ToString());
                if (copy_buffer.Length > 0)
                    Clipboard.SetText(copy_buffer.ToString());
            }
        }

  

        private void listBox_data_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void btn_Readsn_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                currentDataType = DataType.serialNumberData;
                listBox_data.Items.Clear();
                snDataByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadSerialNumber);
                LoadDataToListBox(snDataByteAry);
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();

        }

        private void btn_ReadDeviceID_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                currentDataType = DataType.deviceID;
                listBox_data.Items.Clear();
                deviceIDByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadDeviceID);
                LoadDataToListBox(deviceIDByteAry);
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }


        private void btn_sendABPSetting_Click(object sender, EventArgs e)
        {
            ABPSetting abpsetting = new ABPSetting { DayPeriod = cb_dayPeriod.Text, NightPeriod = cb_nightPeriod.Text, DayInterval = cb_dayInterval.Text, NightInterval = cb_nightInterval.Text, Hi_infPressure = cb_HiInfPressure.Text, HideABPMData = Convert.ToBoolean(cb_hideABPM.Text), Silent = Convert.ToBoolean(cb_silent.Text) };
            if (watchBPO3Hid.CanCommunication)
            {
                this.Cursor = Cursors.WaitCursor;
                if (watchBPO3Hid.SendABPSetting(abpsetting))
                    ShowSetSuccessMsg(true);
                else
                    ShowSetSuccessMsg(false);
                this.Cursor = Cursors.Default;
            }
            else
                ShowConnectDeviceMsg();
        }


        private void btn_readABPDataWH02C_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                IsOscillometric_Map = false;
                this.Cursor = Cursors.WaitCursor;
                currentDataType = DataType.abpData;
                listBox_data.Items.Clear();
                abpDataByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadABPDataE315WithFormula_MAP);
                this.Cursor = Cursors.Default;
                if (!CheckDataExist(abpDataByteAry))
                    return;
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }




        private void btn_readBPMSetting_Click(object sender, EventArgs e)
        {
            if (watchBPO3Hid.CanCommunication)
            {
                currentDataType = DataType.bpmSetting;
                listBox_data.Items.Clear();
                bpmSettingByteAry = watchBPO3Hid.WriteCmd(WatchBPO3Hid.CmdEnum.ReadBPMSetting);
                LoadDataToListBox(bpmSettingByteAry);
                btn_decode_Click(null, null);
            }
            else
                ShowConnectDeviceMsg();
        }

        private void LoadDataToListBox(byte[] rawData)
        {
            listBox_raw.Items.Clear();
            string Str = "0000\t";
            for (int i = 0, j = 0; i < rawData.Length; i++, j++)
            {
                if (j == 10)
                {
                    listBox_raw.Items.Add(Str);
                    Str = i.ToString("0000") + "\t";
                    j = 0;
                }
                Str += rawData[i].ToString("X2") + " ";
            }
            listBox_raw.Items.Add(Str);  // the last string
        }
        private void ChangeAllBtnStatus(bool status)
        {
            btn_clearAll.Enabled = status;
            btn_clearDia.Enabled = status;
            btn_clearUsual.Enabled = status;
            btn_clrAbp.Enabled = status;
            btn_clrMemo.Enabled = status;
            if (status == false)
            {
                btn_readAbpDataWH021.Enabled = status;
                btn_readABPDataWH025.Enabled = status;
                btn_readDiaData.Enabled = status;
                btn_ReadSN.Enabled = status;
                btn_ReadDeviceID.Enabled = status;
                btn_readAbpSetting.Enabled = status;
                btn_sendABPSetting.Enabled = status;
                btn_readABPDataWH02C.Enabled = status;
            }
            if (!watchBPO3Hid.support_Oscillometric_MAP)
                btn_readAbpDataWH021.Enabled = status;

            if (watchBPO3Hid.support_Oscillometric_MAP)
                btn_readABPDataWH025.Enabled = status;

            if (watchBPO3Hid.support_diag_Mode)
                btn_readDiaData.Enabled = status; 

            if (watchBPO3Hid.support_Formula_MAP)
                btn_readABPDataWH02C.Enabled = status;

            if (watchBPO3Hid.support_SN)
            {
                btn_ReadSN.Enabled = status;
            }

            if (watchBPO3Hid.support_Device_ID)
            {
                btn_ReadDeviceID.Enabled = status;
            }

            if (!watchBPO3Hid.support_five_schedule)
            {
                btn_readAbpSetting.Enabled = status;
                btn_sendABPSetting.Enabled = status;
            }

            btn_version.Enabled = status;           
            btn_readCasualData.Enabled = status;
            btn_readDeviceDateTime.Enabled = status;
            btn_readBPMSetting.Enabled = status;
            btn_readID.Enabled = status;
            btn_readMemoData.Enabled = status;
            btn_sendPCdatetime.Enabled = status;
            btn_setID.Enabled = status;

        }

        private bool CheckDataExist(byte[] rawData)
        {
            if (rawData.Length <= 2)    // two ACK (0x06)
            {
                MessageBox.Show("No data!");
                return false;
            }
            else
            {
                LoadDataToListBox(rawData);
                return true;
            }
        }

        private void ShowConnectDeviceMsg()
        {
            MessageBox.Show("Please connect the WatchBP O3 device.");
        }
        private void ShowPhaseOutMsg()
        {
            MessageBox.Show("This device is phase out.");
        }
        private void ShowGetIDMsg()
        {
            MessageBox.Show("Please get the ID of the device.");
        }

        private void ShowDecodeErrMsg()
        {
            MessageBox.Show("Decode error!");
        }

        private void ShowSetSuccessMsg(bool isSuccess)
        {
            if (isSuccess)
                MessageBox.Show("Set up the device successfully!");
            else
                MessageBox.Show("Error!");
        }
    }
}
